package com.ejie.ab04b.control;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.propertyeditors.CustomDateEditor;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.ejie.ab04b.constantes.Constantes;
import com.ejie.ab04b.exception.ErrorField;
import com.ejie.ab04b.exception.ErrorGenericoException;
import com.ejie.ab04b.model.ComunicacionApertura;
import com.ejie.ab04b.model.Proyectista;
import com.ejie.ab04b.service.ProyectistaService;
import com.ejie.ab04b.util.ValidadorNifCifNie;
import com.ejie.x38.control.bind.annotation.RequestJsonBody;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * ProyectistaController generated by UDA, 16-feb-2017 9:14:41.
 * 
 * @author UDA
 */

@Controller()
@RequestMapping(value = "/proyectista")
public class ProyectistaController {

	private static final Logger logger = LoggerFactory
			.getLogger(ProyectistaController.class);

	@Autowired()
	private ProyectistaService ab0483s00Service;

	/**
	 * Usamos este mÃ©todo para indicarle a Spring el formato que debe usar para
	 * serializar las fechas cuando cargamos la entidad en el Model. En el resto
	 * de peticiones que devuelven un objeto con la anotaciÃ³n '@ResponseBody'
	 * se usan los serializadores de UDA
	 * 
	 *  binder
	 *            WebDataBinder
	 *
	 * @param binder the binder
	 */
	@InitBinder()
	public void initBinder(WebDataBinder binder) {

		Locale locale = LocaleContextHolder.getLocale();
		DateFormat dateFormat = null;
		if (locale.equals(Constantes.LOCALE_ES)) {
			dateFormat = new SimpleDateFormat(Constantes.ES_DATE_MASK);
		} else {
			dateFormat = new SimpleDateFormat(Constantes.EU_DATE_MASK);
		}
		binder.registerCustomEditor(Date.class,
				new CustomDateEditor(dateFormat, true));
	}

	/*
	 * OPERACIONES CRUD (Create, Read, Update, Delete)
	 */

	/**
	 * Operacion CRUD Read. Devuelve el bean correspondiente al identificador
	 * indicado.
	 * 
	 *  terexp083
	 *            String
	 *  anoexp083
	 *            String
	 *  numexp083
	 *            Integer
	 *  tipdoc083
	 *            String
	 *  numdoc083
	 *            String
	 *
	 * @param terexp083 the terexp 083
	 * @param anoexp083 the anoexp 083
	 * @param numexp083 the numexp 083
	 * @param tipdoc083 the tipdoc 083
	 * @param numdoc083 the numdoc 083
	 *  Proyectista Objeto correspondiente al identificador indicado.
	 * @return the proyectista
	 */
	@RequestMapping(value = "/{terexp083}/{anoexp083}/{numexp083}/{tipdoc083}/{numdoc083}", method = RequestMethod.GET)
	public @ResponseBody() Proyectista get(@PathVariable() String terexp083,
			@PathVariable() String anoexp083, @PathVariable() Integer numexp083,
			@PathVariable() String tipdoc083,
			@PathVariable() String numdoc083) {
		Proyectista ab0483s00 = new Proyectista();
		ab0483s00.setTerexp083(terexp083);
		ab0483s00.setAnoexp083(anoexp083);
		ab0483s00.setNumexp083(numexp083);
		ab0483s00.setTipdoc083(tipdoc083);
		ab0483s00.setNumdoc083(numdoc083);
		ab0483s00 = this.ab0483s00Service.find(ab0483s00);
		ProyectistaController.logger
				.info("[GET - findBy_PK] : Obtener Proyectista por PK");
		return ab0483s00;
	}

	/**
	 * Devuelve una lista de beans correspondientes a los valores de filtrados
	 * indicados en el objeto pasado como parametro.
	 * 
	 *  filterProyectista
	 *            Proyectista Objeto que contiene los parametros de filtrado
	 *            utilizados en la busqueda.
	 *
	 * @param filterProyectista the filter proyectista
	 *  List<Proyectista> Lista de objetos correspondientes a la busqueda
	 *         realizada.
	 * @return the all
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody() List<Proyectista> getAll(
			@ModelAttribute() Proyectista filterProyectista) {
		ProyectistaController.logger
				.info("[GET - find_ALL] : Obtener Proyectista por filtro");
		return this.ab0483s00Service.findAll(filterProyectista, null);
	}

	/**
	 * Buscar proyectista.
	 * 
	 *  tipoIdentif            String
	 *  numeroDocumento            String
	 *
	 * @param tipoIdentif the tipo identif
	 * @param numeroDocumento the numero documento
	 *  Ramas
	 * @return the proyectista
	 */
	@RequestMapping(value = "buscarProyectista", method = RequestMethod.GET)
	public @ResponseBody() Proyectista buscarProyectista(
			@RequestParam(value = "tipoIdentif") String tipoIdentif,
			@RequestParam(value = "numeroDocumento") String numeroDocumento) {
		Proyectista proyectistaFind = new Proyectista();
		proyectistaFind.setTipdoc083(tipoIdentif);
		proyectistaFind.setNumdoc083(numeroDocumento);

		List<Proyectista> listaProyectistas = this.ab0483s00Service
				.findProyectistaMaxFecAlta(proyectistaFind);

		if (listaProyectistas != null && listaProyectistas.size() > 0) {
			return listaProyectistas.get(0);
		} else {

			throw new ErrorGenericoException("");
		}
	}

	/**
	 * Operacion CRUD Edit. Modificacion del bean indicado.
	 * 
	 *  ab0483s00
	 *            Proyectista Bean que contiene la informacion a modificar.
	 *
	 * @param ab0483s00 the ab 0483 s 00
	 *  Proyectista Bean resultante de la modificacion.
	 * @return the proyectista
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody() Proyectista edit(
			@RequestBody() Proyectista ab0483s00) {

		Proyectista ab0483s00Aux = new Proyectista();

		// Validate
		List<ErrorField> errores = this.validateEditAdd(ab0483s00);
		if (errores != null && !errores.isEmpty()) {
			throw new ErrorGenericoException(errores);
		}

		// validar que no exista un proyectista para la obra sin fecha baja
		Proyectista proyFind = new Proyectista();
		proyFind.setTerexp083(ab0483s00.getTerexp083());
		proyFind.setAnoexp083(ab0483s00.getAnoexp083());
		proyFind.setNumexp083(ab0483s00.getNumexp083());
		proyFind.setTipdoc083(ab0483s00.getTipdoc083());
		proyFind.setNumdoc083(ab0483s00.getNumdoc083());
		// proyFind.setFecbaj083(new Date());
		List<Proyectista> listaProyectistas = this.ab0483s00Service
				.findAll(proyFind, null);

		if (listaProyectistas != null && listaProyectistas.size() > 0) {
			errores.add(new ErrorField("aperturas.detalle.proyectistas",
					"error.proyectista.activo"));

			if (!errores.isEmpty()) {
				throw new ErrorGenericoException(errores);
			}
		}

		try {
			ab0483s00Aux = this.ab0483s00Service.update(ab0483s00);
		} catch (Exception e) {
			throw new ErrorGenericoException("");
		}
		ProyectistaController.logger
				.info("[PUT] : Proyectista actualizado correctamente");
		return ab0483s00Aux;
	}

	/**
	 * Operacion CRUD Create. Creacion de un nuevo registro a partir del bean
	 * indicado.
	 * 
	 *  ab0483s00
	 *            Proyectista Bean que contiene la informacion con la que se va
	 *            a crear el nuevo registro.
	 *  request
	 *            HttpServletRequest
	 *
	 * @param ab0483s00 the ab 0483 s 00
	 * @param request the request
	 *  Proyectista Bean resultante del proceso de creacion.
	 * @return the proyectista
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody() Proyectista add(@RequestBody() Proyectista ab0483s00,
			HttpServletRequest request) {

		HttpSession session = request.getSession();
		ComunicacionApertura comunicAperturaSess = new ComunicacionApertura();
		if (session != null) {
			comunicAperturaSess = (ComunicacionApertura) session.getAttribute(
					ComunicacionAperturaController.ATTR_NAME_COMUNICAPERTURA_DETALLE);

			if (comunicAperturaSess != null) {
				ab0483s00.setTerexp083(comunicAperturaSess.getTerape056());
				ab0483s00.setAnoexp083(comunicAperturaSess.getAnoape056());
				ab0483s00.setNumexp083(
						comunicAperturaSess.getNumape056().intValue());
				if (comunicAperturaSess.getCodobra056() != null) {
					ab0483s00
							.setCodobra083(comunicAperturaSess.getCodobra056());
				}
			}

		}
		Proyectista ab0483s00Aux = new Proyectista();

		// Validate
		List<ErrorField> errores = this.validateEditAdd(ab0483s00);
		if (errores != null && !errores.isEmpty()) {
			throw new ErrorGenericoException(errores);
		}

		// validar que no exista un proyectista para la obra sin fecha baja
		Proyectista proyFind = new Proyectista();
		proyFind.setTerexp083(ab0483s00.getTerexp083());
		proyFind.setAnoexp083(ab0483s00.getAnoexp083());
		proyFind.setNumexp083(ab0483s00.getNumexp083());
		proyFind.setTipdoc083(ab0483s00.getTipdoc083());
		proyFind.setNumdoc083(ab0483s00.getNumdoc083());
		proyFind.setCodobra083(ab0483s00.getCodobra083());
		// proyFind.setFecbaj083(new Date());
		List<Proyectista> listaProyectistas = this.ab0483s00Service
				.findAll(proyFind, null);

		if (listaProyectistas != null && listaProyectistas.size() > 0) {
			errores.add(new ErrorField("aperturas.detalle.proyectistas",
					"error.proyectista.activo"));

			if (!errores.isEmpty()) {
				throw new ErrorGenericoException(errores);
			}
		}

		try {
			ab0483s00.setUsualt083("prueba");
			ab0483s00Aux = this.ab0483s00Service.add(ab0483s00);
		} catch (Exception e) {
			throw new ErrorGenericoException("");
		}

		ProyectistaController.logger
				.info("[POST] : Proyectista insertado correctamente");
		return ab0483s00Aux;
	}

	/**
	 * Operacion CRUD Delete. Borrado del registro correspondiente al
	 * identificador especificado.
	 * 
	 *  terexp083
	 *            String
	 *  anoexp083
	 *            String
	 *  numexp083
	 *            Integer
	 *  tipdoc083
	 *            String
	 *  numdoc083
	 *            String
	 *  request
	 *            HttpServletRequest
	 *
	 * @param terexp083 the terexp 083
	 * @param anoexp083 the anoexp 083
	 * @param numexp083 the numexp 083
	 * @param tipdoc083 the tipdoc 083
	 * @param numdoc083 the numdoc 083
	 * @param request the request
	 *  Proyectista Bean eliminado.
	 * @return the proyectista
	 */
	@RequestMapping(value = "/{terexp083}/{anoexp083}/{numexp083}/{tipdoc083}/{numdoc083}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody() Proyectista remove(@PathVariable() String terexp083,
			@PathVariable() String anoexp083, @PathVariable() Integer numexp083,
			@PathVariable() String tipdoc083, @PathVariable() String numdoc083,
			HttpServletRequest request) {

		HttpSession session = request.getSession();
		Proyectista ab0483s00 = new Proyectista();
		ComunicacionApertura comunicAperturaSess = new ComunicacionApertura();
		if (session != null) {
			comunicAperturaSess = (ComunicacionApertura) session.getAttribute(
					ComunicacionAperturaController.ATTR_NAME_COMUNICAPERTURA_DETALLE);

			if (comunicAperturaSess != null
					&& comunicAperturaSess.getCodobra056() != null) {
				ab0483s00.setCodobra083(comunicAperturaSess.getCodobra056());
			}

		}

		ab0483s00.setTerexp083(terexp083);
		ab0483s00.setAnoexp083(anoexp083);
		ab0483s00.setNumexp083(numexp083);
		ab0483s00.setTipdoc083(tipdoc083);
		ab0483s00.setNumdoc083(numdoc083);
		this.ab0483s00Service.remove(ab0483s00);
		ProyectistaController.logger
				.info("[DELETE] : Proyectista borrado correctamente");
		return ab0483s00;
	}

	/*
	 * METODOS COMPONENTE RUP_TABLE
	 */

	/**
	 * Metodo de presentacion del RUP_TABLE.
	 * 
	 *  model
	 *            Model
	 *
	 * @param model the model
	 *  String
	 * @return the form edit
	 */
	@RequestMapping(value = "/maint", method = RequestMethod.GET)
	public String getFormEdit(Model model) {
		ProyectistaController.logger.info("[GET - View] : ab0483s00");
		return "tabProyectistas";
	}

	/**
	 * Operacion de filtrado del componente RUP_TABLE.
	 * 
	 *  filterProyectista
	 *            Proyectista Bean que contiene los parametros de filtrado a
	 *            emplear.
	 *  jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 *  request
	 *            HttpServletRequest
	 *
	 * @param filterProyectista the filter proyectista
	 * @param jqGridRequestDto the jq grid request dto
	 * @param request the request
	 *  JQGridResponseDto<Proyectista> Dto que contiene el resultado del
	 *         filtrado realizado por el componente RUP_TABLE.
	 * @return the JQ grid response dto
	 */
	@RequestMapping(value = "/filter", method = RequestMethod.POST)
	public @ResponseBody() JQGridResponseDto<Proyectista> filter(
			@RequestJsonBody(param = "filter") Proyectista filterProyectista,
			@RequestJsonBody() JQGridRequestDto jqGridRequestDto,
			HttpServletRequest request) {
		ProyectistaController.logger
				.info("[POST - filter] : Obtener Proyectistas");

		HttpSession session = request.getSession();
		ComunicacionApertura comunicAperturaSess = new ComunicacionApertura();
		if (session != null) {
			comunicAperturaSess = (ComunicacionApertura) session.getAttribute(
					ComunicacionAperturaController.ATTR_NAME_COMUNICAPERTURA_DETALLE);

			if (comunicAperturaSess != null) {
				filterProyectista
						.setTerexp083(comunicAperturaSess.getTerape056());
				filterProyectista
						.setAnoexp083(comunicAperturaSess.getAnoape056());
				filterProyectista.setNumexp083(
						comunicAperturaSess.getNumape056().intValue());
				if (comunicAperturaSess.getCodobra056() != null) {
					filterProyectista
							.setCodobra083(comunicAperturaSess.getCodobra056());
				}
			}

		}

		return this.ab0483s00Service.filter(filterProyectista, jqGridRequestDto,
				false);
	}

	/**
	 * Operacion de busqueda del componente RUP_TABLE.
	 * 
	 *  filterProyectista
	 *            Proyectista Bean que contiene los parametros de filtrado a
	 *            emplear.
	 *  searchProyectista
	 *            Proyectista Bean que contiene los parametros de busqueda a
	 *            emplear.
	 *  jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en la búsqueda.
	 *
	 * @param filterProyectista the filter proyectista
	 * @param searchProyectista the search proyectista
	 * @param jqGridRequestDto the jq grid request dto
	 *  TableRowDto<Proyectista> Dto que contiene el resultado de la
	 *         busqueda realizada por el componente RUP_TABLE.
	 * @return the list
	 */
	@RequestMapping(value = "/search", method = RequestMethod.POST)
	public @ResponseBody() List<TableRowDto<Proyectista>> search(
			@RequestJsonBody(param = "filter") Proyectista filterProyectista,
			@RequestJsonBody(param = "search") Proyectista searchProyectista,
			@RequestJsonBody() JQGridRequestDto jqGridRequestDto) {
		ProyectistaController.logger
				.info("[POST - search] : Buscar Proyectistas");
		return this.ab0483s00Service.search(filterProyectista,
				searchProyectista, jqGridRequestDto, false);
	}

	/**
	 * Borrado multiple de registros.
	 * 
	 *  filterProyectista            Proyectista Bean que contiene los parametros de filtrado a
	 *            emplear.
	 *  jqGridRequestDto            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en la busqueda.
	 *
	 * @param filterProyectista the filter proyectista
	 * @param jqGridRequestDto the jq grid request dto
	 *  List<String> Lista de los identificadores de los registros
	 *         eliminados.
	 * @return the list
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody() List<String> removeMultiple(
			@RequestJsonBody(param = "filter") Proyectista filterProyectista,
			@RequestJsonBody() JQGridRequestDto jqGridRequestDto) {
		ProyectistaController.logger.info(
				"[POST - search] : [POST - removeMultiple] : Eliminar multiples Proyectistas");
		this.ab0483s00Service.removeMultiple(filterProyectista,
				jqGridRequestDto, false);
		ProyectistaController.logger.info("All entities correctly deleted!");

		return jqGridRequestDto.getMultiselection().getSelectedIds();
	}

	/*
	 * METODOS COMPONENTE RUP_TABLE - JERARQUIA
	 */

	/**
	 * Operacion de filtrado del componente RUP_TABLE para presentar los
	 * registros mediante visualizacion jerarquica.
	 * 
	 *  filterProyectista
	 *            Proyectista Bean que contiene los parametros de filtrado a
	 *            emplear.
	 *  jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 *
	 * @param filterProyectista the filter proyectista
	 * @param jqGridRequestDto the jq grid request dto
	 *  JQGridResponseDto<JerarquiaDto<Proyectista>> Dto que contiene el
	 *         resultado del filtrado realizado por el componente RUP_TABLE.
	 * @return the JQ grid response dto
	 */
	@RequestMapping(value = "/jerarquia/filter", method = RequestMethod.POST)
	public @ResponseBody() JQGridResponseDto<JerarquiaDto<Proyectista>> jerarquia(
			@RequestJsonBody(param = "filter") Proyectista filterProyectista,
			@RequestJsonBody() JQGridRequestDto jqGridRequestDto) {
		ProyectistaController.logger
				.info("[POST - jerarquia] : Obtener Proyectistas jerarquia");
		return this.ab0483s00Service.jerarquia(filterProyectista,
				jqGridRequestDto, false);
	}

	/**
	 * Recupera los hijos de los registros desplegados en la visualizacion
	 * jerarquica.
	 * 
	 *  filterProyectista
	 *            Proyectista Bean que contiene los parametros de filtrado a
	 *            emplear.
	 *  jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 *
	 * @param filterProyectista the filter proyectista
	 * @param jqGridRequestDto the jq grid request dto
	 *  JQGridResponseDto<JerarquiaDto<Proyectista>> Dto que contiene el
	 *         resultado del filtrado realizado por el componente RUP_TABLE.
	 * @return the JQ grid response dto
	 */
	@RequestMapping(value = "/jerarquiaChildren", method = RequestMethod.POST)
	public @ResponseBody() JQGridResponseDto<JerarquiaDto<Proyectista>> jerarquiaChildren(
			@RequestJsonBody(param = "filter") Proyectista filterProyectista,
			@RequestJsonBody() JQGridRequestDto jqGridRequestDto) {
		ProyectistaController.logger.info(
				"[POST - jerarquia] : Obtener Proyectistas jerarquia - Hijos");
		return this.ab0483s00Service.jerarquiaChildren(filterProyectista,
				jqGridRequestDto);
	}

	/**
	 * Validate edit add.
	 * 
	 *  proyectista            Proyectista
	 *
	 * @param proyectista the proyectista
	 *  List<ErrorField>
	 * @return the list
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity
	private List<ErrorField> validateEditAdd(Proyectista proyectista) {
		List<ErrorField> errorFields = new ArrayList<ErrorField>();

		if (proyectista.getTipdoc083() == null) {
			errorFields.add(new ErrorField("aperturas.detalle.tipoIdentif",
					"error.tipocifnif"));
		}
		if (proyectista.getNumdoc083() == null) {
			errorFields.add(new ErrorField("aperturas.detalle.numDoc",
					"validacion.obligatorio"));

		} else if (proyectista.getNumdoc083() != null
				&& Constantes.TIPO_CIF.equals(proyectista.getTipdoc083())
				&& !ValidadorNifCifNie
						.isCifValido(proyectista.getNumdoc083())) {
			errorFields.add(new ErrorField("aperturas.detalle.numDoc",
					"error.cif.incorrecto"));
		} else if (proyectista.getNumdoc083() != null
				&& Constantes.TIPO_NIF.equals(proyectista.getTipdoc083())
				&& !ValidadorNifCifNie
						.isNifValido(proyectista.getNumdoc083())) {
			errorFields.add(new ErrorField("aperturas.detalle.numDoc",
					"error.nif.incorrecto"));
		}

		if (proyectista.getPaispry083() != null && Constantes.ID_PAIS_ESPANA
				.equals(proyectista.getPaispry083())) {
			if (proyectista.getCodProvincia() == null) {
				errorFields.add(new ErrorField("aperturas.detalle.provincia",
						"validacion.obligatorio"));
			}
			if (proyectista.getCodMunicipio() == null) {
				errorFields.add(new ErrorField("aperturas.detalle.municipio",
						"validacion.obligatorio"));
			}
		} else {
			if (proyectista.getDmunpry083() == null
					|| "".equals(proyectista.getDmunpry083())) {
				errorFields
						.add(new ErrorField("aperturas.detalle.munipExtranjero",
								"validacion.obligatorio"));
			}
		}

		return errorFields;
	}

}
